/************************************************************************
 * @file: AudioFaderTest.cpp
 *
 * @description: Unit Test for GDA.
 *
 * @authors: Athreya Manasa Balaraj, ManasaBalaraj.Athreya@in.bosch.com 2017
 *           Devi Laxmi, Laxmi.Devi@in.bosch.com 2017
 *
 * copyright (c) 2015 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 ***********************************************************************/

#include <dlt/dlt.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <gst/gst.h>

/*! @file main.c
 *  Simple DLT application.
 */
#include "gst_player.h"

/* @brief Main Module */
int
main (int argc, char *argv[])
{
    argc = argc;
    argv = argv;
    uint32_t      player_cnt;
    GThread       *main_thread[PLAYER_INSTANCE_CNT];
    player_info_t player_info[PLAYER_INSTANCE_CNT];
    GDA_ER err[PLAYER_INSTANCE_CNT] = {GDA_OK};

    if ( argc != 2 )
    {
        g_print( "GDA test needs a audio file to be passed as command line arg\n");
        return -1;
    }

    DLT_REGISTER_APP ("GDLT", "GST-DLT Application");

    gst_init (&argc, &argv);
    for(player_cnt = 0; player_cnt < PLAYER_INSTANCE_CNT ; player_cnt++)
    {
        player_info[player_cnt].player_inst = player_cnt;
        err[player_cnt] = gst_initialize (&player_info[player_cnt]);
        player_info[player_cnt].filename = argv[1];
        main_thread[player_cnt] = g_thread_new ("Main-thread", gst_create_pipeline_thread,
                (void*)&player_info[player_cnt]);
    }
    for(player_cnt = 0; player_cnt < PLAYER_INSTANCE_CNT ; player_cnt++)
    {
        g_thread_join (main_thread[player_cnt]);
        if(err[player_cnt] == GDA_OK)
        {
            err[player_cnt] = gst_finalize (&player_info[player_cnt].gda_ctx);
        }
    }

    DLT_UNREGISTER_APP ();
    for(player_cnt = 0; player_cnt < PLAYER_INSTANCE_CNT ; player_cnt++)
    {
        if(err[player_cnt] != GDA_OK)
            return err[player_cnt];
    }
    return 0;
}
